#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <DHT.h>

#include <Servo.h>
Servo myservo;

#include <Arduino.h>
#include <pitches.h>
#define buz 6
#define REST     1
// TONES  ==========================================
// notes in the melody:
int Mario_melody[] = {
  NOTE_E4, NOTE_E4, REST, NOTE_E4, 
  REST, NOTE_C4, NOTE_E4, REST,
  NOTE_G4, REST, REST, NOTE_G3, REST,
  
  NOTE_C4, REST, REST, NOTE_G3,
  REST, NOTE_E3, REST,
  REST, NOTE_A3, REST, NOTE_B3,   
  REST, NOTE_AS3, NOTE_A3, REST,
  
  NOTE_G3, NOTE_E4, NOTE_G4,
  NOTE_A4, REST, NOTE_F4, NOTE_G4, 
  REST, NOTE_E4, REST, NOTE_C4, 
  NOTE_D4, NOTE_B3, REST
 };
 
int Mario_Notes[] = {
  4, 4, 4, 4,
  4, 4, 4, 4,
  4, 2, 4, 2, 2,
  
  4, 4, 4, 4,
  2, 4, 4,
  4, 4, 4, 4,  
  4, 4, 4, 4,
  
  4, 2, 4,
  4, 4, 4, 4,
  4, 4, 4, 4, 
  4, 4, 2
  };
  
const int num_elements_in_arr = sizeof(Mario_Notes)/sizeof(Mario_Notes[0]);

// 코딩어레이 로고 이미지 비트맵 
const unsigned char codingarray [] PROGMEM = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfc, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xc7, 0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xcf, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x9f, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xf8, 0x1f, 0xe0, 0x7e, 0x01, 0xf8, 0xc3, 0xf1, 0xf8, 0x1f, 
  0xbf, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xf0, 0x07, 0x80, 0x1e, 0x00, 0xf8, 0xc3, 0xf1, 0xe0, 0x07, 
  0x3f, 0x00, 0x00, 0x00, 0x0f, 0xdf, 0xc0, 0x07, 0x00, 0x0e, 0x00, 0x38, 0xc1, 0xf1, 0xc0, 0x07, 
  0x3e, 0x00, 0x00, 0x00, 0x07, 0xcf, 0xc3, 0xee, 0x0f, 0x86, 0x3c, 0x38, 0xc0, 0xf1, 0xc3, 0xef, 
  0x3c, 0x00, 0x00, 0x00, 0x07, 0xcf, 0x87, 0xfe, 0x3f, 0xc6, 0x3e, 0x18, 0xc0, 0xf1, 0x8f, 0xff, 
  0x3c, 0x00, 0x00, 0x00, 0x03, 0xcf, 0x8f, 0xfe, 0x3f, 0xc2, 0x3f, 0x18, 0xc0, 0x71, 0x8f, 0xff, 
  0x3c, 0x00, 0x00, 0x00, 0x03, 0xcf, 0x8f, 0xfc, 0x7f, 0xe2, 0x3f, 0x18, 0xc4, 0x71, 0x1f, 0xff, 
  0x3c, 0x00, 0x00, 0x00, 0x03, 0xcf, 0x9f, 0xfc, 0x7f, 0xe2, 0x3f, 0x98, 0xc4, 0x31, 0x1f, 0x01, 
  0x3c, 0x00, 0x00, 0x00, 0x03, 0xcf, 0x8f, 0xfc, 0x7f, 0xe2, 0x3f, 0x18, 0xc6, 0x31, 0x1f, 0x00, 
  0x3c, 0x00, 0x40, 0x01, 0x83, 0xcf, 0x8f, 0xfe, 0x3f, 0xe2, 0x3f, 0x18, 0xc7, 0x11, 0x8f, 0x00, 
  0x3c, 0x07, 0xf8, 0x03, 0xc3, 0xcf, 0x8f, 0xfe, 0x3f, 0xc6, 0x3f, 0x18, 0xc7, 0x01, 0x8f, 0xe1, 
  0x3c, 0x0f, 0xfe, 0x07, 0xe3, 0xcf, 0xc7, 0xfe, 0x1f, 0x86, 0x3e, 0x38, 0xc7, 0x81, 0x87, 0xe1, 
  0x3c, 0x1f, 0xfe, 0x0f, 0xe3, 0xcf, 0xc1, 0x87, 0x06, 0x0e, 0x18, 0x38, 0xc7, 0x81, 0xc1, 0x83, 
  0x3c, 0x3f, 0xfc, 0x1f, 0xe3, 0xcf, 0xe0, 0x07, 0x80, 0x1e, 0x00, 0x78, 0xc7, 0xc1, 0xe0, 0x07, 
  0x3c, 0x3f, 0xf8, 0x3f, 0xe3, 0xcf, 0xf8, 0x0f, 0xc0, 0x3e, 0x01, 0xf8, 0xc7, 0xe1, 0xf0, 0x0f, 
  0x3c, 0x7e, 0x00, 0x7f, 0xe3, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x38, 0x7c, 0x00, 0xff, 0xe1, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x7c, 0x01, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x7c, 0x03, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x38, 0x7c, 0x07, 0xf7, 0xe1, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x3c, 0x7e, 0x0f, 0xe7, 0xe3, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x3c, 0x7f, 0xbf, 0xc7, 0xe3, 0xcf, 0xfc, 0x3f, 0x00, 0xf0, 0x1f, 0xf1, 0xf8, 0xf1, 0xff, 0xff, 
  0x3c, 0x3f, 0xff, 0x87, 0xe3, 0xcf, 0xfc, 0x3f, 0x00, 0x70, 0x0f, 0xe0, 0xf8, 0x61, 0xff, 0xff, 
  0x3c, 0x1f, 0xff, 0x07, 0xe3, 0xcf, 0xf8, 0x3f, 0x00, 0x70, 0x0f, 0xe0, 0xfc, 0x63, 0xff, 0xff, 
  0x3c, 0x0f, 0xfe, 0x07, 0xe3, 0xcf, 0xf8, 0x1f, 0x1c, 0x33, 0xc7, 0xe0, 0xfc, 0x03, 0xff, 0xff, 
  0x3c, 0x07, 0xfc, 0x07, 0xe3, 0xcf, 0xf0, 0x1f, 0x1e, 0x33, 0xc7, 0xc0, 0x7e, 0x07, 0xff, 0xff, 
  0x3c, 0x01, 0xe0, 0x03, 0xc3, 0xcf, 0xf1, 0x1f, 0x1c, 0x73, 0x87, 0xc4, 0x7e, 0x07, 0xff, 0xff, 
  0x3c, 0x00, 0x00, 0x00, 0x03, 0xcf, 0xf1, 0x8f, 0x00, 0x70, 0x0f, 0xc4, 0x7f, 0x0f, 0xff, 0xff, 
  0x3c, 0x00, 0x00, 0x00, 0x03, 0xcf, 0xe1, 0x8f, 0x00, 0xf0, 0x1f, 0x8e, 0x3f, 0x0f, 0xff, 0xff, 
  0x3c, 0x00, 0x00, 0x00, 0x03, 0xcf, 0xe0, 0x07, 0x01, 0xf0, 0x3f, 0x80, 0x3f, 0x9f, 0xff, 0xff, 
  0x3c, 0x00, 0x00, 0x00, 0x03, 0xcf, 0xe0, 0x07, 0x11, 0xf2, 0x1f, 0x00, 0x1f, 0x9f, 0xff, 0xff, 
  0x3c, 0x00, 0x00, 0x00, 0x07, 0xcf, 0xc0, 0x07, 0x18, 0xf3, 0x1f, 0x00, 0x1f, 0x9f, 0xff, 0xff, 
  0x3e, 0x00, 0x00, 0x00, 0x07, 0xcf, 0xc7, 0xe3, 0x18, 0xf3, 0x0f, 0x1f, 0x1f, 0x9f, 0xff, 0xff, 
  0x3f, 0x00, 0x00, 0x00, 0x0f, 0xdf, 0xc7, 0xe3, 0x1c, 0x73, 0x8e, 0x3f, 0x8f, 0x9f, 0xff, 0xff, 
  0xbf, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x8f, 0xe3, 0x1c, 0x73, 0x8e, 0x3f, 0x8f, 0x9f, 0xff, 0xff, 
  0x9f, 0xff, 0xff, 0xff, 0xff, 0x9f, 0x8f, 0xf1, 0x1e, 0x33, 0xc6, 0x3f, 0x8f, 0x9f, 0xff, 0xff, 
  0xcf, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xc7, 0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfc, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


#define DHTPIN 12
#define DHTTYPE DHT11
DHT dht(DHTPIN, DHTTYPE);

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels

//Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
#define OLED_RESET -1 // Reset pin # (or -1 if sharing Arduino reset pin)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

long mil = 0;
long ledt = 0;
long buzt = 0;
long lcdt = 0;
long dist = 0;
long lit = 0;
float temp, humi;
unsigned long dura = 0;
float dst = 0;
int leds = 0;
int bar = 0;

void setup() {
  Serial.begin(9600); // 디버깅 메시지 출력을 위해 시리얼 모니터 활성화
  Wire.begin();
    
  pinMode(8,INPUT);
  pinMode(7,INPUT);
  pinMode(13,OUTPUT);
  pinMode(9,OUTPUT);
  pinMode(10,OUTPUT);
  pinMode(11,OUTPUT);
  pinMode(5,OUTPUT);                // 5번에triger핀연결
  pinMode(4,INPUT);                 // 4번 핀에 echo핀 연결

  dht.begin();
  myservo.attach(3);
  myservo.write(0);  

  
  // SSD1306_SWITCHCAPVCC = 내부 3.3V 차지 펌프 회로를 켜둔다.
  // OLED 주소 0x3C 지정
  
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  // 버퍼 지움
  display.clearDisplay();
  // 비트맵 이미지 출력
  display.drawBitmap(0, 0, codingarray, 128, 64, WHITE);
  display.display();
  
  // 반전 이미지 
  //display.invertDisplay(1);

  myservo.write(180 - int(bar / 5.68));

  for (int thisNote = 0; thisNote < num_elements_in_arr; thisNote++) // 슈퍼마리오 멜로디 톤 발생
  {
    if (digitalRead(7)) {
      break;
    }
    // to calculate the note duration, take one second
    // divided by the note type.
    //e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
    int noteDuration = 500 / Mario_Notes[thisNote];
    tone(6, Mario_melody[thisNote], noteDuration);

    // to distinguish the notes, set a minimum time between them.
    // the note's duration + 30% seems to work well:
    int pauseBetweenNotes = noteDuration * 1.30;
    delay(pauseBetweenNotes);
    // stop the tone playing:
    noTone(6);
  }


  
}

void displayTempHumid(){
  //delay(250);
  // Reading temperature or humidity takes about 250 milliseconds!
  // Sensor readings may also be up to 2 seconds 'old' (its a very slow sensor)
  float h = dht.readHumidity();
  // Read temperature as Celsius
  float t = dht.readTemperature();
  // Read temperature as Fahrenheit
  float f = dht.readTemperature(true);

  //초음파 센서로 거리 측정
  //digitalWrite(5, LOW);  //PULSE ___|---|___
  //delayMicroseconds(2); 
  digitalWrite(5, HIGH);
  delayMicroseconds(10); 
  digitalWrite(5, LOW);
  float Duration =pulseIn(4, HIGH);                 // echo핀이 HIGH 유지한 시간 저장
  float Distance=((float)(340 *Duration) /10000) /2;              // 거리를 cm로환산


  // Check if any reads failed and exit early (to try again).
  if (isnan(h) || isnan(t) || isnan(f)) {
    display.clearDisplay(); // clearing the display
    display.setTextColor(WHITE); //setting the color
    display.setTextSize(1); //set the font size
    display.setCursor(5,45); //set the cursor coordinates
    display.print("Failed to read from DHT sensor!");
    display.display();
    return;
  }

  // 버퍼 지움
  display.clearDisplay();

  display.setTextColor(WHITE);
  display.setTextSize(1);
  display.setCursor(24,2);
  display.print("Coding Array!"); 
  display.setCursor(0,14);
  display.print("Humidity: "); 
  display.print(h);
  display.print(" %\t");
  display.setCursor(0,24);
  display.print("Temperature: "); 
  display.print(t);
  display.print(" C"); 
  display.setCursor(0,36);
  display.print("Temperature: "); 
  display.print(f);
  display.print(" F"); 

  //isplay.setTextSize(1);
  display.setCursor(0,47);
  //display.setCursor(20,10);
  unsigned int Distance_buffer = Distance;
  display.print(Distance_buffer);
  //isplay.print(f);
  display.print(" cm");
  display.display();
}


void loop() {

  mil = millis();
  //prints time since program started
  //Serial.println(mil);

  displayTempHumid();

  //가변저항 수치
  bar = analogRead(A0);

  //서보
  myservo.write(180 - int(bar / 5.68));

  //부저울림 시작
  if (mil > buzt) {
    buzt = mil + 800;
    tone(buz, bar * 1.3 + 50, 40);
  }

  //택트스위치
  if (digitalRead(8) == HIGH) 
  {
    digitalWrite(13, HIGH);
  } 
  else 
  {
    digitalWrite(13, LOW);
  }
  
  //RGB led
  if (digitalRead(7) == HIGH || analogRead(A2) < 480) 
  {
    if (mil > ledt) 
    {
      ledt = mil + 100;
      leds++;
      if (leds == 1) 
      {
        digitalWrite(9, HIGH);
        digitalWrite(11, LOW);
      } 
      else if (leds == 2) 
      {
        digitalWrite(10, HIGH);
        digitalWrite(9, LOW);
      } else {
        digitalWrite(11, HIGH);
        digitalWrite(10, LOW);
      }
      if (leds == 3) {
        leds = 0;
      }
    }
  } 
  else 
  {
    digitalWrite(9, LOW);
    digitalWrite(10, LOW);
    digitalWrite(11, LOW);
  }

}
